## DeepSeek华丽文风从何而来？业内人士：训练数据、训练策略和迭代优化缺一不可


“他们说我是魔、是妖、是异数。可谁见过，莲花在淤泥里，如何长出自己的形状。”“我割开血肉，剔出龙筋，还给东海一个太平。却还不清，这具身体的债。”“乾坤圈在手腕上，长成另一道年轮。风火轮碾过陈塘关的黄昏，碾碎每一块试图定义我的石碑。”这是笔者让 DeepSeek 根据当前热门电影《哪吒之魔童闹海》为哪吒写的一首诗的节选。

![img](https://pic.yupi.icu/yuyi/1739511722220-b9233351-6c2e-4900-a298-51e2766abce9.png)（来源：DeepSeek）

旅游博主“福瑞环宇”用 DeepSeek 写了一首关于使徒保罗的诗，写完之后这位博主感慨道：“写出来一看简直要去地上找下巴。它竟然能把特洛伊和特罗亚区分得那么清楚，也艺术性地写出了特罗亚的位置、保罗在特罗亚发生的两件重要的事，还给人呈现了一个全然摆上的保罗，最后一句‘一粒麦子埋入欧洲的春秋’更是惊艳又深沉到无以复加。”

## 一、通过后训练阶段两个步骤协同实现华丽风格

事实上，DeepSeek 不仅会写诗，其走心的回答风格已经让不少用户直呼“戳中心窝”。毫无疑问，DeepSeek 华丽抒情走心的文风展现了 AI 温暖的一面。那么，是什么技术促成了这样的风格？

上海交通大学副教授赵波表示，通过一些试用可以发现，DeepSeek 主要包含八种角色设定：电影角色、新闻主持、历史人物、动漫游戏、文学角色、职业角色、搞笑角色和科幻角色。每种角色大类又分别包含其类型中的经典人物。DeepSeek 可以按照用户要求，模仿特定角色的语言或行文风格与用户交互。这一能力来源自然是训练数据，这需要 DeepSeek 的开发者针对丰富的角色/风格/场景，收集对应的多轮对话和指令跟随数据来训练模型。而这些数据的来源可能是原始资料数据、人工标注数据、模型合成数据等。

美国耶鲁大学助理教授杨卓然从微观角度给出了一些解读。他表示根据 DeepSeek‑V3 技术报告，**DeepSeek 的华丽文风主要是通过后训练阶段的两个步骤协同实现的。**

第一个步骤是监督微调（SFT，Supervised Fine-Tuning）。在监督微调阶段，模型接触到了大量高质量的语言表达示例，尤其是针对创意写作等非推理任务的数据。杨卓然表示，具体来说对于创意写作任务，初始回答由 DeepSeek‑V2.5 生成，随后经过人工审核来确保内容的准确性和风格的一致性。正是在这部分数据中，模型学习到了大量语言表达优美、用词讲究的示例，这为它后续生成华丽文风奠定了基础。

第二个步骤是强化学习（RL，Reinforcement Learning）。在强化学习阶段，模型利用奖励机制进一步优化生成结果。对于诸如创意写作这样的开放式任务，奖励模型会对生成的回答进行评分，不仅要求答案准确，还鼓励模型在措辞、句式和逻辑上表现得更加精致、富有文采。奖励模型基于监督微调阶段得到的 DeepSeek‑V3 checkpoints 进行训练，并通过高温采样和多步优化，使模型在生成时逐步融合精美的修辞和细腻的表达方式。

北京邮电大学副教授白婷则综合 DeepSeek 的多款模型，从宏观角度给出了一些解读。她表示，DeepSeek 曾在技术报告里提到一些关键技术：比如 DeepSeek-V2 使用了 Multi-Head Latent Attention 和 Sparse MoE 架构，其中 Multi-Head Latent Attention 是为了提高模型效率，MoE 架构则能通过利用多专家能力来提高模型能力。DeepSeek-V3 把多专家架构加入辅助函数进行负载均衡的优化，同时也加入了强化学习进行增强。DeepSeek-R1 版本则是解决模型推理能力，它直接使用强化学习去指导思维链的生成，并通过知识蒸馏赋予小模型以更大的能力。

白婷指出，DeepSeek 所采用的技术并非独创，此前学界和业界已经开始使用这些技术，甚至一些团队的某些单项技术上做得比 DeepSeek 还要更好。“为什么 DeepSeek 能取得如此的成功和关注度？我想其中包含了许多大模型研究者都可望不可及的两点：大量算力资源和大量高质量的训练数据以及适宜的训练策略。”她表示。算力无需多言，有实力的大公司在这方面基本不相上下。而华丽的文风或者说是 DeepSeek 的回复较其他模型更“像人”，则是因为受到了上述关键技术手段的影响，**但更为关键核心要素则是高质量训练数据、训练策略和大量迭代优化的结果。**

## 二、数据即模型：数据质量带动模型性能

2024 年 3 月，DeepSeek 公司的研究员陈德里曾在一场业界大会上发表过题为《和而不同：大语言模型价值观对齐解耦化》的演讲，演讲中他提到：“在实际模型生产过程中，我们会进行模型的迭代式开发；即每轮的训练结束之后，都会有一个独立的测试团队，对模型在上述各个维度上的安全性进行充分的测试，并给出反馈意见来指导进行下一个周期的数据迭代和模型训练。”由此可见，DeepSeek 在模型数据方面一定有独到之处。

![img](https://pic.yupi.icu/yuyi/1739511722128-a7c9cc4f-8721-44bc-8f35-ef56519e5568.png)（来源：https://maimai.cn/article/detail?fid=1826052238&efid=WRuDmSQ74-wciyw4PYW5Qw）

杨卓然指出，数据质量对模型训练至关重要，不仅影响模型获取和表达知识的能力，还决定了模型生成内容的风格和准确性。

其一，高质量数据可以提升模型表达和推理能力。优质数据包含准确、连贯且富有表现力的语言样本。例如，包含链式思考（COT，Chain of Thought）数据可以引导模型在推理时进行反思，进而在生成回答时展现出清晰的逻辑和优美的语言表达。这正是模型能够生成既准确又具有华丽文风的关键因素之一。

其二，高质量数据可以降低噪音和确保一致性。数据中的错误、噪音或不一致信息会导致模型生成内容出现语法或逻辑问题。高质量的数据则能有效减少这些问题，使模型更好地学习到语言规律，从而提高整体生成质量。

其三，高质量数据可以提升泛化能力。数据的多样性和全面性使得模型在面对不同领域和任务时都能生成高质量的回答。丰富且准确的样本帮助模型在多种场景下自如切换风格，无论是精炼的技术解答还是文采斐然的创意写作，都能游刃有余。

其四，只需少量高质量数据就能显著提高模型能力。最近一些论文比如《s1: Simple test-time scaling》和《LIMO: Less is More for Reasoning》也强调，数据质量极为关键。即便只有少量高质量的数据，也能显著提升模型的能力，因为高质量数据中蕴含的信息更为准确和代表性，为模型提供了高效的学习信号。“这种‘精炼’数据不仅帮助模型在推理和生成上达到更高水准，还能更快收敛以及降低训练成本。”杨卓然表示。

白婷也认同上述观点。她表示：“以我们开发的百家智能体大模型（baijia.online）为例，我们在阿里 Qwen-7B 上的微调后的结果反超 DeepSeek-2.5-238B。”当通过收集大量低资源、分散的历史语料，以此来构造训练数据和训练策略，此时模型基座的能力强弱就不再是取得决胜性因素的关键。也就是说，高质量训练数据的使用能够大大增强大模型在某一目标任务上的能力。事实上，DeepSeek 也有角色扮演的能力，比如它能很好地扮演李白。但是，对于低资源的人物，其效果就比较一般，所以数据质量和训练策略是其背后的两大原因。“比如我们开发的百家智能体大模型就采用了 RLAIF 的方式将高资源角色丰富的朝代、背景等信息迁移协同低资源人物的构造。”她说。

DeepSeek 的回复比其他模型更具某种风格，比如更加活泼、更加严谨等，这其实反映在工程师对于对话数据的构造和提示方式上。而对于模型生成内容质量的影响，一种是将所有数据都通过预训练方式内化到模型内部，一种是通过检索的方式将更加精准的知识召回。前者的泛化性很强，但是容易出现幻觉，毕竟庞大的知识会导致混乱，不能专而精深。而后者则是一种人机协同的方式，检索的内容可以是人类构建的带有一定可信度的网页内容、史料等，使得大模型回复更加可信。

**赵波也表示，数据质量对模型训练起到决定性作用。可以说数据即模型，有多高质量的数据就可以得到多强大的模型。** 随着训练数据的不断收集，大模型研究团队对数据的关注逐渐从数据规模转移到数据质量。大量实例证明：小规模高质量数据能够训练得到比大规模低质量数据更好的模型，并且训练成本更低。赵波举例称，2023 年微软的 Phi-2 模型使用“教科书质量”的训练数据实现了小模型高性能。此外，合成数据也已成为大模型训练数据的重要来源，通过合成可以低成本地获得大量高质量数据。目前，主流大模型的训练都使用了大量的合成数据。赵波和团队也于 2023 年 7 月推出过针对多模态大模型训练的百万级高质量合成数据集 SVIT 等。

## 三、尾声

白婷补充称，无论是 AGI 还是 Agent, 其本质上都是模拟并超越人类这一目前最高等的智能体。从 DeepSeek 的设计上来看，不管是早期 DeepSeek-V2 版本中多专家 MoE 的群体决策，还是 DeepSeek-R1 版本中思维链的推理能力，知识蒸馏的学习能力的加强，都能很契合地对应到人类做出决策时的反应和采取的行为。但是，只有这些能力是远远不够的，更高效强大的记忆系统、共情能力、反思进化能力、个性化能力，都是后期大模型发展、超越、服务人类时需要具备的能力。在此，也期待 DeepSeek 带来更惊艳的表现。



> 来源：https://news.qq.com/rain/a/20250209A058YE00?utm_source=chatgpt.com